﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.VistaPharmacyModels;
using PpmsDataWebService.ModelsEnumTypes;
using VA.PPMS.Context;
using Microsoft.Xrm.Client.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System.Diagnostics;
using Microsoft.Xrm.Sdk.Messages;

namespace PpmsDataWebService.Mappers
{
    public class VistaPharmacyProviderMap
    {
        public static async Task<IQueryable<VistaPharmacyProvider>> MapVistaPharmacyProviders(List<Account> ppmsProviders,string queryType, IOrganizationService _service)
        {
            var providerList = new List<VistaPharmacyProvider> { };            
            int count = 0;
            
            foreach (var ppmsProvider in ppmsProviders)
            {
                count += 1;                         
                var provider = new VistaPharmacyProvider
                {
                    NPI = Convert.ToInt64(ppmsProvider.ppms_ProviderIdentifier),
                    FirstName = ppmsProvider.ppms_ProviderFirstName,
                    LastName = ppmsProvider.ppms_ProviderLastName,
                    MainPhone = ppmsProvider.Telephone1,
                    Fax = ppmsProvider.Fax,
                };

                //Provider Type Switch. 
                if (ppmsProvider.ppms_providertype != null)
                    switch (ppmsProvider.ppms_providertype.Value)
                    {
                        case (int)Account_ppms_providertype.Individual:
                            provider.ProviderType = ProviderType.Individual;                          
                            break;
                        case (int)Account_ppms_providertype.GroupPracticeAgency:
                            provider.ProviderType = ProviderType.GroupPracticeOrAgency;                      
                            break;
                    }

                //Gender
                if (ppmsProvider.ppms_gender != null)
                    switch (ppmsProvider.ppms_gender.Value)
                    {
                        case (int)ppms_Gender.Male:
                            provider.Gender = ProviderGender.Male;
                            break;
                        case (int)ppms_Gender.Female:
                            provider.Gender = ProviderGender.Female;
                            break;
                        case (int)ppms_Gender.NotSpecified:
                            provider.Gender = ProviderGender.NotSpecified;
                            break;
                        case (int)ppms_Gender.Other:
                            provider.Gender = ProviderGender.Other;
                            break;
                    }

                //Status
                if (ppmsProvider.StatusCode != null)
                    switch (ppmsProvider.StatusCode.Value)
                    {
                        case (int)Account_StatusCode.Active:
                            provider.StatusReason = ProviderStatusReason.Active;
                            break;
                        case (int)Account_StatusCode.AddressValidation:
                            provider.StatusReason = ProviderStatusReason.AddressValidation;
                            break;
                        case (int)Account_StatusCode.Deactivated:
                            provider.StatusReason = ProviderStatusReason.Deactivated;
                            break;
                        case (int)Account_StatusCode.Hold:
                            provider.StatusReason = ProviderStatusReason.Hold;
                            break;
                        case (int)Account_StatusCode.Inactive:
                            provider.StatusReason = ProviderStatusReason.Inactive;
                            break;
                        case (int)Account_StatusCode.LEIEExclusion:
                            provider.StatusReason = ProviderStatusReason.LeieExclusion;
                            break;
                        case (int)Account_StatusCode.LicenseExpiration:
                            provider.StatusReason = ProviderStatusReason.LicenseExpiration;
                            break;
                        case (int)Account_StatusCode.NPICheckFailure:
                            provider.StatusReason = ProviderStatusReason.NpiCheckFailure;
                            break;
                        case (int)Account_StatusCode.PendingReview:
                            provider.StatusReason = ProviderStatusReason.PendingReview;
                            break;
                        case (int)Account_StatusCode.SAMSExclusion:
                            provider.StatusReason = ProviderStatusReason.SamsExclusion;
                            break;
                        case (int)Account_StatusCode.ValidationProcess:
                            provider.StatusReason = ProviderStatusReason.ValidationProcess;
                            break;
                    } 
                providerList.Add(provider);              
            }          
            var provs = providerList.AsQueryable();
            return provs;
        }
    }
}